/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.base;

import filenet.vw.api.VWClassFactory;
import filenet.vw.api.VWException;
import filenet.vw.api.VWGuid;
import filenet.vw.api.VWSession;
import filenet.vw.api.VWSystemConfiguration;
import filenet.vw.base.CEObjectInfo;
import filenet.vw.base.SdfFileInfo;
import java.util.Hashtable;

public class CEObjectInfoCache {
    private VWSession m_vwSession = null;
    private SdfFileInfo m_sdfFileInfo = null;
    private Hashtable<String, CEObjectInfo> m_ceObjectList = new Hashtable();

    public CEObjectInfoCache(VWSession vwSession, VWSystemConfiguration sysConfig, String sdfFileContents) throws VWException {
        this.m_vwSession = vwSession;
        this.parseSdfFileContents(sdfFileContents);
    }

    public CEObjectInfo getCEClassDefinition(VWGuid classId) throws VWException {
        if (classId == null || classId.isUndefined()) {
            return null;
        }
        String keyStr = classId.toString();
        if (this.m_ceObjectList.containsKey(keyStr)) {
            return this.m_ceObjectList.get(keyStr);
        }
        CEObjectInfo ceObj = null;
        if (this.m_vwSession != null && (ceObj = VWClassFactory.fetchCEObjectInfo(this.m_vwSession, this.getObjectStoreGuid(), null, classId, 234L)) != null) {
            this.m_ceObjectList.put(keyStr, ceObj);
        }
        return ceObj;
    }

    public CEObjectInfo getCEObject(VWGuid classId, VWGuid objectId) throws VWException {
        if (classId == null || classId.isUndefined() || objectId == null || objectId.isUndefined()) {
            return null;
        }
        String keyStr = objectId.toString();
        if (this.m_ceObjectList.containsKey(keyStr)) {
            return this.m_ceObjectList.get(keyStr);
        }
        CEObjectInfo ceObj = null;
        if (this.m_vwSession != null && (ceObj = VWClassFactory.fetchCEObjectInfo(this.m_vwSession, this.getObjectStoreGuid(), classId, objectId, 234L)) != null) {
            this.m_ceObjectList.put(keyStr, ceObj);
        }
        return ceObj;
    }

    public SdfFileInfo getSdfFileInfo() {
        return this.m_sdfFileInfo;
    }

    private void parseSdfFileContents(String sdfFileContents) throws VWException {
        if (sdfFileContents == null || sdfFileContents.length() == 0) {
            return;
        }
        CEObjectInfo baseCaseFolder = null;
        CEObjectInfo baseCaseTask = null;
        try {
            VWGuid objectStoreId;
            if (this.m_vwSession != null && (objectStoreId = this.getObjectStoreGuid()) != null) {
                baseCaseFolder = VWClassFactory.ShortCircuit_fetchCEObjectInfoByName(this.m_vwSession, objectStoreId, "CmAcmCaseFolder", 234L);
                baseCaseTask = VWClassFactory.ShortCircuit_fetchCEObjectInfoByName(this.m_vwSession, objectStoreId, "CmAcmCaseTask", 234L);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        try {
            int i;
            this.m_sdfFileInfo = new SdfFileInfo(sdfFileContents, baseCaseFolder, baseCaseTask);
            CEObjectInfo[] ceObjInfos = this.m_sdfFileInfo.getCaseObjects();
            if (ceObjInfos != null) {
                for (i = 0; i < ceObjInfos.length; ++i) {
                    if (ceObjInfos[i] == null || ceObjInfos[i].getGuid() == null) continue;
                    this.m_ceObjectList.put(ceObjInfos[i].getGuid(), ceObjInfos[i]);
                }
            }
            if ((ceObjInfos = this.m_sdfFileInfo.getTaskObjects()) != null) {
                for (i = 0; i < ceObjInfos.length; ++i) {
                    if (ceObjInfos[i] == null || ceObjInfos[i].getGuid() == null) continue;
                    this.m_ceObjectList.put(ceObjInfos[i].getGuid(), ceObjInfos[i]);
                }
            }
        }
        catch (Throwable t) {
            VWException ex = new VWException("vw.base.CEObjectInfoCache.ErrorParsingSDFFile", "The Solution Definition File could not be parsed. See the root cause for additional information.");
            ex.setCause(t);
            throw ex;
        }
    }

    private VWGuid getObjectStoreGuid() throws VWException {
        VWGuid objectStoreId = null;
        if (this.m_vwSession != null) {
            objectStoreId = this.m_vwSession.getObjectStoreId();
        }
        if (objectStoreId == null) {
            throw new VWException("vw.base.CEObjectInfoCache.NullObjectStoreId", "The object store GUID could not be retrieved. The object store GUID has not been set on the isolated region.");
        }
        return objectStoreId;
    }
}

